# Project11CS | BCS 36 

Knapsack Problem Solver is a Java application that solves the Knapsack Problem using a Genetic Algorithm. The application allows the user to define the parameters of the problem and the algorithm, and then run the algorithm to solve the problem. The application also allows the user to save the results of the algorithm to a file.

## Getting Started

To get a local copy up and running follow these simple steps.

### Installation

1. Clone the repo
   ```sh
   git clone https://gitlab.maastrichtuniversity.nl/bcs_group36_2023/project-1-1.git 
   cd project-1-1
   ```
2. Install Maven dependencies
   ```sh
    mvn install
    ```
3. Build the project
   ```sh
    mvn compile
   ```
4. ```sh
    mvn clean package
   ```
5. Run the project
   ```sh
    java --module-path /path/to/javafx-sdk-21.0.2/lib --add-modules javafx.controls,javafx.fxml -jar target/project11cs-3.0.jar
   ```
### Prerequisites

- Java SDK 21
- Maven
- 
### Running the application

To run the application, navigate to the directory containing the JAR file and run the following command:

```bash
java --module-path /path/to/javafx-sdk-21.0.2/lib --add-modules javafx.controls,javafx.fxml -jar project11cs-3.0.jar
```

#### Optional
- Docker

### Building the Docker Image

To build the Docker image, navigate to the directory containing the Dockerfile and run the following command:

```bash
docker build -t project11cs .
```

# Running the Docker Container
Docker, primarily used for running background applications, can also run GUI applications. While this usage is not very common, it can be beneficial for offloading resource-intensive tasks to Docker containers for specific GUI applications.

To run GUI applications, you need to have XServer installed on your local machine

## Running On MacOS

### Prerequisites:
- Install XQuartz from https://www.xquartz.org. Installation of XQuartz will require to restart your machine.
- Ensure the xhost command is available after installation.
- Configure XQuartz to allow connections from network clients from Preferences -> Security tab

### To run:
1. On your local machine, start XQuartz
2. Run `xhost + ${hostname}` after
3. Set DISPLAY var in the container: `export DISPLAY=<IP>:0`
4. Run `xclock` in the container to test the X11
5. Now you can run your app with GUI

```bash 
 docker run -it --rm -e DISPLAY=host.docker.internal:0 project11cs java --module-path /app/javafx-sdk-21.0.2/lib --add-modules javafx.controls,javafx.fxml -jar /app/project11cs-3.0.jar
``````

## Running On Linux

### Prerequisites:

### To run:
1. On your local machine, start XQuartz
2. Run `xhost + ${hostname}` in the local machine
3. Set DISPLAY var in the container: `export DISPLAY=<IP>:0.0`
4. Run `xclock` in the container to test the X11
5. Now you can run your app with GUI

```bash 
 docker run -it --rm -e DISPLAY=host.docker.internal:0 project11cs java --module-path /app/javafx-sdk-21.0.2/lib --add-modules javafx.controls,javafx.fxml -jar /app/project11cs-3.0.jar
``````

## Running On Windows

### Prerequisites:
- Install VcXsrv Windows X Server (https://sourceforge.net/projects/vcxsrv/) manually or `choco install vcxsrv`
- Run Xlaunch from the start menu and perform the initial configuration.
- Make sure to save to configuration file before you click finish. Save it to one of the following locations:
    - `%appdata%\Xming`
    - `%userprofile%\Desktop`
    - `%userprofile%`

### To run:
1. Run Xlaunch
2. Find up by `ipconfig` on the local machine
3. Set DISPLAY var in the container: `export DISPLAY=<IP>:0.0`
4. Run `xclock` in the container to test the X11
5. Now you can run your app with GUI

```bash 
 docker run -it --rm -e DISPLAY=host.docker.internal:0 project11cs java --module-path /app/javafx-sdk-21.0.2/lib --add-modules javafx.controls,javafx.fxml -jar /app/project11cs-3.0.jar
``````

## Authors
- [Angelos Vasilikiotis](mailto:a.vasilikiotis@student.maastrichtuniversity.nl)

- [Etienne Huijdts](mailto:etle.huijdts@student.maastrichtuniversity.nl)

- [Luigelo Davila](mailto:l.davilavilchez@student.maastrichtuniversity.nl)

- [Stylliani Mikeli](mailto:s.mikelli@student.maastrichtuniversity.nl)

- [Greg Vadasz](mailto:g.vadasz@student.maastrichtuniversity.nl)

## License
This project is licensed under the MIT License - see the LICENSE.md file for details

