package com.bsc36.project11cs.models;

import com.bsc36.project11cs.config.BasicConfig;

import java.util.ArrayList;
import java.util.List;

public class Parcel {
    // Declare the attributes of the parcel
    private int id;
    private String color;
    private String name;
    private int[][][] shape;
    private final char type;
    private int volume;
    private List<int[][][]> rotations;


    public Parcel(char type) {
        this.type = type;
        setType(type);
        initializeRotations();
    }

    /**
     * Set Parcel Type
     * @param type Char Type
     */
    private void setType(char type) {
        switch (type) {
            case 'A' -> {
                this.id = 1;
                this.color = BasicConfig.A_PARCEL_COLOR;
                this.name = "Parcel " + type;
                this.volume = 16;
                initializeRotations();
                this.shape = new int[][][] {
                    {{1, 1}, {1, 1}},
                    {{1, 1}, {1, 1}},
                    {{1, 1}, {1, 1}},
                    {{1, 1}, {1, 1}}
                };
            }
            case 'B' -> {
                this.id = 2;
                this.color = BasicConfig.B_PARCEL_COLOR;
                this.name = "Parcel " + type;
                this.volume = 24;
                initializeRotations();
                this.shape = new int[][][] {
                    {{1, 1}, {1, 1}, {1, 1}, {1, 1}}, 
                    {{1, 1}, {1, 1}, {1, 1}, {1, 1}}, 
                    {{1, 1}, {1, 1}, {1, 1}, {1, 1}}
                };
            }
            case 'C' -> {
                this.id = 3;
                this.color = BasicConfig.C_PARCEL_COLOR;
                this.name = "Parcel " + type;
                this.volume = 27;
                initializeRotations();
                this.shape = new int[][][] {
                    {{1, 1, 1}, {1, 1, 1}, {1, 1, 1}},
                    {{1, 1, 1}, {1, 1, 1}, {1, 1, 1}},
                    {{1, 1, 1}, {1, 1, 1}, {1, 1, 1}}
                };
            }
            case 'P' -> {
                this.id = 4;
                this.color = BasicConfig.P_PARCEL_COLOR;
                this.name = "Pentomino " + type;
                this.volume = 5;
                initializeRotations();
                this.shape = new int[][][] {
                    {{1, 1, 1}, {1, 1, 0}}
                };
            }
            case 'L' -> {
                this.id = 5;
                this.color = BasicConfig.L_PARCEL_COLOR;
                this.name = "Pentomino " + type;
                this.volume = 5;
                initializeRotations();
                this.shape = new int[][][] {
                    {{1, 0}}, 
                    {{1, 0}}, 
                    {{1, 0}}, 
                    {{1, 1}}
                };
            }
            case 'T' -> {
                this.color = BasicConfig.T_PARCEL_COLOR;
                this.id = 6;
                this.name = "Pentomino " + type;
                this.volume = 5;
                initializeRotations();
                this.shape = new int[][][] {
                        {{1, 1, 1}, {0, 1, 0}, {0, 1, 0}}
                };
            }
            default -> {
                this.name = "Undefined";
                this.shape =  new int[][][] {{}};
            }
        }
    }

    public void initializeRotations() {
        rotations = new ArrayList<>();

        // Add original shape
        rotations.add(shape);

        // Add rotations based on type
        switch (type) {
            case 'A' -> {
                // Rotations for Parcel A
                rotations.add(new int[][][] {
                    {{1, 1}, {1, 1}},
                    {{1, 1}, {1, 1}},
                    {{1, 1}, {1, 1}},
                    {{1, 1}, {1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1, 1}, {1, 1, 1, 1}},
                    {{1, 1, 1, 1}, {1, 1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}, {1, 1}, {1, 1}, {1, 1}}, 
                    {{1, 1}, {1, 1}, {1, 1}, {1, 1}}
                });
            }
            case 'B' -> {
                // Rotations for Parcel B
                rotations.add(new int[][][] {
                    {{1, 1}, {1, 1}, {1, 1}, {1, 1}}, 
                    {{1, 1}, {1, 1}, {1, 1}, {1, 1}}, 
                    {{1, 1}, {1, 1}, {1, 1}, {1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1, 1}, {1, 1, 1, 1}, {1, 1, 1, 1}}, 
                    {{1, 1, 1, 1}, {1, 1, 1, 1}, {1, 1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1}, {1, 1, 1}, {1, 1, 1}, {1, 1, 1}}, 
                    {{1, 1, 1}, {1, 1, 1}, {1, 1, 1}, {1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}, {1, 1}, {1, 1}}, 
                    {{1, 1}, {1, 1}, {1, 1}}, 
                    {{1, 1}, {1, 1}, {1, 1}}, 
                    {{1, 1}, {1, 1}, {1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1, 1}, {1, 1, 1, 1}}, 
                    {{1, 1, 1, 1}, {1, 1, 1, 1}}, 
                    {{1, 1, 1, 1}, {1, 1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1}, {1, 1, 1}}, 
                    {{1, 1, 1}, {1, 1, 1}}, 
                    {{1, 1, 1}, {1, 1, 1}}, 
                    {{1, 1, 1}, {1, 1, 1}}
                });
            }
            // Add cases for other parcel types...
            case 'C' -> {
                // Rotations for Parcel C
                rotations.add(new int[][][] {
                    {{1, 1, 1}, {1, 1, 1}, {1, 1, 1}},
                    {{1, 1, 1}, {1, 1, 1}, {1, 1, 1}},
                    {{1, 1, 1}, {1, 1, 1}, {1, 1, 1}}
                });
            }
            case 'L' -> {
                // Rotations for Parcel C
                rotations.add(new int[][][] {
                    {{1, 1, 1, 1}},
                    {{1, 0, 0, 0}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}, {1}, {1}}, 
                    {{1}, {0}, {0}, {0}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}, {1}, {1}}, 
                    {{0}, {0}, {0}, {1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1, 1}}, 
                    {{0, 0, 0, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {0}, {0}, {0}}, 
                    {{1}, {1}, {1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{1, 0, 0, 0}}, 
                    {{1, 1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0}, {0}, {0}, {1}}, 
                    {{1}, {1}, {1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{0, 0, 0, 1}}, 
                    {{1, 1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}, {1, 0}, {1, 0}, {1, 0}}
                });
                rotations.add(new int[][][] {
                    {{1, 0, 0, 0}, {1, 1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0, 1}, {0, 1}, {0, 1}, {1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1, 1}, {0, 0, 0, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}, {0, 1}, {0, 1}, {0, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1, 1}, {1, 0, 0, 0}}
                });
                rotations.add(new int[][][] {
                    {{1, 0}, {1, 0}, {1, 0}, {1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0, 0, 0, 1}, {1, 1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {0}}, 
                    {{1}, {0}}, 
                    {{1}, {0}}, 
                    {{1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{1, 0}}, 
                    {{1, 0}}, 
                    {{1, 0}}, 
                    {{1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0}, {1}}, 
                    {{0}, {1}}, 
                    {{0}, {1}}, 
                    {{1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{0, 1}}, 
                    {{0, 1}}, 
                    {{0, 1}}, 
                    {{1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}}, 
                    {{1}, {0}}, 
                    {{1}, {0}}, 
                    {{1}, {0}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}}, 
                    {{1, 0}}, 
                    {{1, 0}}, 
                    {{1, 0}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}}, 
                    {{0}, {1}}, 
                    {{0}, {1}}, 
                    {{0}, {1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}}, 
                    {{0, 1}}, 
                    {{0, 1}}, 
                    {{0, 1}}
                });
            }
            case 'P' -> {
                // Rotations for Parcel C
                rotations.add(new int[][][] {
                    {{1, 1, 1}, {1, 1, 0}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}, {1, 1}, {1, 0}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 0}, {1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0, 1}, {1, 1}, {1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1}, {0, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}, {1, 1}, {0, 1}}
                });
                rotations.add(new int[][][] {
                    {{1, 0}, {1, 1}, {1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0, 1, 1}, {1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}, {0}}, 
                    {{1}, {1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 0}}, 
                    {{1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0}, {1}, {1}}, 
                    {{1}, {1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{0, 1, 1}}, 
                    {{1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}, {1}}, 
                    {{1}, {1}, {0}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1}}, 
                    {{1, 1, 0}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}, {1}}, 
                    {{0}, {1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1}}, 
                    {{0, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {0}}, 
                    {{1}, {1}}, 
                    {{1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{1, 0}}, 
                    {{1, 1}}, 
                    {{1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0}, {1}}, 
                    {{1}, {1}}, 
                    {{1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{0, 1}}, 
                    {{1, 1}}, 
                    {{1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}}, 
                    {{1}, {1}}, 
                    {{0}, {1}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}}, 
                    {{1, 1}}, 
                    {{0, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}}, 
                    {{1}, {1}}, 
                    {{1}, {0}}
                });
                rotations.add(new int[][][] {
                    {{1, 1}}, 
                    {{1, 1}}, 
                    {{1, 0}}
                });
            }
            case 'T' -> {
                // Rotations for Parcel C
                rotations.add(new int[][][] {
                    {{1, 1, 1}, {0, 1, 0}, {0, 1, 0}}
                });
                rotations.add(new int[][][] {
                    {{1, 0, 0}, {1, 1, 1}, {1, 0, 0}}
                });
                rotations.add(new int[][][] {
                    {{0, 1, 0}, {0, 1, 0}, {1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{0, 0, 1}, {1, 1, 1}, {0, 0, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {0}, {0}}, 
                    {{1}, {1}, {1}}, 
                    {{1}, {0}, {0}}
                });
                rotations.add(new int[][][] {
                    {{1, 0, 0}}, 
                    {{1, 1, 1}}, 
                    {{1, 0, 0}}
                });
                rotations.add(new int[][][] {
                    {{0}, {0}, {1}}, 
                    {{1}, {1}, {1}}, 
                    {{0}, {0}, {1}}
                });
                rotations.add(new int[][][] {
                    {{0, 0, 1}}, 
                    {{1, 1, 1}}, 
                    {{0, 0, 1}}
                });
                rotations.add(new int[][][] {
                    {{0}, {1}, {0}}, 
                    {{0}, {1}, {0}}, 
                    {{1}, {1}, {1}}
                });
                rotations.add(new int[][][] {
                    {{0, 1, 0}}, 
                    {{0, 1, 0}}, 
                    {{1, 1, 1}}
                });
                rotations.add(new int[][][] {
                    {{1}, {1}, {1}}, 
                    {{0}, {1}, {0}}, 
                    {{0}, {1}, {0}}
                });
                rotations.add(new int[][][] {
                    {{1, 1, 1}}, 
                    {{0, 1, 0}}, 
                    {{0, 1, 0}}
                });
            }
        }
    }
    

    /**
     * Get the list of rotations for the parcel.
     * @return List<int[][][]> List of rotations
     */
    public List<int[][][]> getRotations() {
        return rotations;
    }

    /**
     * Get Parcel Id
     * @return int Id Value
     */
    public int getId() {
        return id;
    }

    /**
     * Get Parcel Shape
     * @return int[][][] Shape Value
     */
    public int[][][] getShape() {
        return shape;
    }

    /**
     * Set Parcel Shape
     * @param shape int[][][] Shape Value
     */
    public void setShape(int[][][] shape) {
        this.shape = shape;
    }

    /**
     * Get Parcel Value
     * @return int Value Value
     */
    public String getName() {
        return name;
    }

    /**
     * Get Parcel Color
     * @return String Color Value
     */
    public String getColor() {
        return color;
    }

    /**
     * Get Parcel Type
     * @return char Type Value
     */
    public char getType() {
        return type;
    }

    public int getVolume(){
        return volume;
    }

}
